// tutorial.c

#include "main.h"
#include "tutorial.h"
#include "level.h"
#include "font.h"
#include "pause.h"
#include "gworld.h"
#include "graphics.h"
#include "control.h"
#include "blitter.h"
#include "gameticks.h"
#include "soundfx.h"
#include "opponent.h"
#include "keyboard.h"

#include <string.h>

AutoPattern tutorialPattern[] =
{
	{ kMessage,        0,   0,   "Welcome to the\nCandy Crisis\ntutorial!" },
	{ kIdleTicks,      180, 0,   nil },
	{ kMessage,        0,   0,   "I'll be your guide\nthroughout the\ntutorial. Let's\nget started!" },
	{ kRetrieve,       1,   1,   nil },
	{ kIdleTicks,      240, 0,   nil },	
	{ kMessage,        0,   0,   "When you start the\ngame, you'll find a\npair of candies\nfalling from the sky." },
	{ kIdleTicks,      240, 0,   nil },	
	{ kMessage,        0,   0,   "Your goal is to\nkeep these candies\nfrom overflowing the\nboard!" },
	{ kBlockUntilLand, 0,   0,   nil },
	{ kRetrieve,       2,   2,   nil },
	{ kIdleTicks,      60,  0,   nil },
	{ kMessage,        0,   0,   "You control the\ncandy by moving\nthem left and right." },
	{ kIdleTicks,      120, 0,   nil },
	{ kPosition,       0,   0,   nil },
	{ kIdleTicks,      120, 0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kMessage,        0,   0,   "Press '~~~~~~~~~'\nto make the pieces\nmove left." },
	{ kRetrieve,       3,   3,   nil },
	{ kIdleTicks,      60,  0,   nil },
	{ kPosition,       5,   0,   nil },
	{ kIdleTicks,      90,  0,   nil },
	{ kMessage,        0,   0,  "Use '|||||||||' to\nmake the pieces\nmove right." },
	{ kIdleTicks,      180, 0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kMessage,        0,   0,   "You can also\nmake the pieces\nrotate around each\nother." },
	{ kRetrieve,       4,   3,   nil },
	{ kIdleTicks,      180, 0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kMessage,        0,   0,   "Press '{{{{{{{{{'\nto make the pieces\nrotate." },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kPosition,       5,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kMessage,        0,   0,   "Also, '`````````'\ncauses the candy\nto drop faster." },
	{ kIdleTicks,      180, 0,   nil },	
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kMessage,        0,   0,   "To pause the game\nor adjust settings,\npress 'esc.'" },
	{ kIdleTicks,      280, 0,   nil },	
	{ kMessage,        0,   0,   "The candy in\nthis game is made\nfrom a highly\nunstable substance!" },
	{ kRetrieve,       2,   2,   nil },
	{ kIdleTicks,      200, 0,   nil },
	{ kMessage,        0,   0,   "So when four\npieces of the same\ncolor come into\ncontact..." },
	{ kPosition,       1,   0,   nil },
	{ kIdleTicks,      180, 0,   nil },
	{ kMessage,        0,   0,   "... they vaporize!" },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kIdleTicks,      60,  0,   nil },
	{ kMessage,        0,   0,   "Let's see that\nonce again." },
	{ kRetrieve,       1,   1,   nil },
	{ kIdleTicks,      120, 0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kMessage,        0,   0,   "Pop!" },
	{ kIdleTicks,      120, 0,   nil },	
	{ kMessage,        0,   0,   "You can even get\nfive or more\npieces to pop\nall at the same\ntime!" },
	{ kRetrieve,       4,   4,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kPosition,       4,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       4,   4,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kPosition,       3,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       4,   4,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kPosition,       4,   0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kMessage,        0,   0,   "Pop!\n\nTechniques like this\ncan earn lots of\nbonus points." },
	{ kIdleTicks,      180, 0,   nil },
	{ kMessage,        0,   0,   "You can also pop\nmore than one color\nat once." },
	{ kRetrieve,       5,   5,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kPosition,       4,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kRetrieve,       6,   5,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kPosition,       3,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kRetrieve,       3,   5,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      10,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      10,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kPosition,       5,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kMessage,        0,   0,   "All right!" },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kRetrieve,       0,   6,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kMessage,        0,   0,   "You can even set\nup devastating\nchain reactions..." },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kRetrieve,       0,   6,   nil },
	{ kIdleTicks,      90,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kRetrieve,       6,   6,   nil },
	{ kIdleTicks,      60,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kRetrieve,       0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kPosition,       1,   0,   nil },
	{ kMessage,        0,   0,   "... like this!" },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kMessage,        0,   0,   "Tricky, isn't it?" },
	{ kRetrieve,       1,   2,   nil },
	{ kIdleTicks,      60,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kRetrieve,       1,   2,   nil },
	{ kIdleTicks,      60,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kRetrieve,       3,   1,   nil },
	{ kIdleTicks,      60,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kRetrieve,       3,   2,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kPosition,       3,   0,   nil },
	{ kMessage,        0,   0,  "Let's see one more\nexample of a chain\nreaction." },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kRetrieve,       1,   2,   nil },
	{ kIdleTicks,      60,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       5,   5,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kPosition,       1,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       5,   3,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      10,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      10,  0,   nil },
	{ kPosition,       1,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       3,   5,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kPosition,       0,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      10,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       3,   3,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kPosition,       0,   0,   nil },
	{ kIdleTicks,      20,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kIdleTicks,      90,  0,   nil }, 
	{ kMessage,        0,   0,   "There's one more\nthing you need to\nknow about..." },
	{ kIdleTicks,      180, 0,   nil },
	{ kMessage,        0,   0,   "Watch out for the\nsee-through candy!" },
	{ kIdleTicks,      60,  0,   nil },
	{ kPunish,         18,  0,   nil },
	{ kRetrieve,       1,   1,   nil },
	{ kIdleTicks,      120, 0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kPosition,       0,   0,   nil },
	{ kIdleTicks,      20,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kMessage,        0,   0,   "When your opponent\nvaporizes a group of\ncandies, they also\nsend some transparent\npieces to you!" },
	{ kRetrieve,       1,   1,   nil },
	{ kIdleTicks,      90,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kPosition,       4,   0,   nil },
	{ kIdleTicks,      30,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       1,   1,   nil },
	{ kIdleTicks,      60,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      90,  0,   nil },
	{ kMessage,        0,   0,   "You can get rid of\nthese pieces by\nvaporizing something\nnext to them." },
	{ kIdleTicks,      150, 0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kIdleTicks,      60,  0,   nil },
	{ kRetrieve,       1,   2,   nil },
	{ kMessage,        0,   0,   "There are also\nsome bonus items\nwhich can come\nin handy." },
	{ kIdleTicks,      20,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kPosition,       0,   0,   nil },
	{ kIdleTicks,      20,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       3,   1,   nil },
	{ kIdleTicks,      20,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      10,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      10,  0,   nil },
	{ kPosition,       0,   0,   nil },
	{ kIdleTicks,      20,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       1,   3,   nil },
	{ kIdleTicks,      10,  0,   nil },
	{ kPosition,       1,   0,   nil },
	{ kIdleTicks,      15,  0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kMessage,        0,   0,   "One of these bonus\nitems is the Crazy\nCandy!" },
	{ kRetrieve,       -1,  2,   nil },
	{ kIdleTicks,      15,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      10,  0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      100, 0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kMessage,        0,   0,   "The Crazy Candy\ntakes on the\ncolor of one of\nits neighbors." },
	{ kIdleTicks,      60,  0,   nil },
	{ kRetrieve,       3,   4,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kPosition,       4,   0,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       1,   5,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kPosition,       1,   0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kMessage,        0,   0,   "Another useful bonus\nitem is the bomb!" },
	{ kRetrieve,       2,   3,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kPosition,       0,   0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       0,   3,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       3,   2,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kPosition,       5,   0,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       4,   3,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kPosition,       3,   0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve,       2,   3,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kSpin,           0,   0,   nil },
	{ kIdleTicks,      5,   0,   nil },
	{ kPosition,       5,   0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },	
	{ kRetrieve, kBombBottom, kBombTop, nil },
	{ kMessage,        0,   0,   "When the bomb lands\non one color\nof candy, all\npieces of that\ncolor will\nvaporize!" },
	{ kIdleTicks,      100, 0,   nil },
	{ kPosition,       4,   0,   nil },
	{ kIdleTicks,      120, 0,   nil },
	{ kBlockUntilDrop, 0,   0,   nil },
	{ kIdleTicks,      200, 0,   nil },
	{ kMessage,        0,   0,   "Now you're ready\nto play Candy Crisis.\nGood luck!" },
	{ kIdleTicks,      270, 0,   nil },

	{ kComplete,       0,   0,   nil }
};

char *keyBackMap[0x80] =
{
	"A",
	"S",
	"D",
	"F",
	"H",
	"G",
	"Z",
	"X",
	"C",
	"V",
	"??",
	"B",
	"Q",
	"W",
	"E",
	"R",
	"Y",
	"T",
	"1",
	"2",
	"3",
	"4",
	"6",
	"5",
	"=",
	"9",
	"7",
	"-",
	"8",
	"0",
	"]",
	"O",
	"U",
	"[",
	"I",
	"P",
	"return",
	"L",
	"J",
	"\"",
	"K",
	";",
	"backslash",
	",",
	"/",
	"N",
	"M",
	".",
	"tab",
	"",
	"tilde",
	"delete",
	"??",
	"esc",
	"??",
	"command",
	"shift",
	"caps lock",
	"option",
	"control",
	"??",
	"??",
	"??",
	"??",
	"??",
	".",
	"??",
	"*",
	"??",
	"+",
	"??",
	"clear",
	"??",
	"??",
	"??",
	"/",
	"enter",
	"??",
	"-",
	"??",
	"??",
	"=",
	"0",
	"1",
	"2",
	"3",
	"4",
	"5",
	"6",
	"7",
	"??",
	"8",
	"9",
	"??",
	"??",
	"??",
	"F5",
	"F6",
	"F7",
	"F3",
	"F8",
	"F9",
	"??",
	"F11",
	"??",
	"F13",
	"??",
	"F14",
	"??",
	"F10",
	"??",
	"F12",
	"??",
	"F15",
	"ins",
	"home",
	"page up",
	"del",
	"F4",
	"end",
	"F2",
	"page down",
	"F1",
	"left",
	"right",
	"down",
	"up",
	"??"
};

Rect balloonRect = {0, 0, 190, 210};
SkittlesFontPtr balloonFont;
Point balloonPt;
char *balloonChar;
char balloonMsg[256];
int balloonTime, tutorialTime;
GWorldPtr balloonWorld = nil;

void InitTutorial( void )
{
	Rect backdropRect;
	
	// Balloon font
	balloonFont = GetFont( picBalloonFont );
	
	// Balloon backbuffer
	if( balloonWorld == nil )
	{
		GetPortBounds( backdropWorld, &backdropRect );
		InitGWorld( &balloonWorld, &backdropRect, 16 );
	}
	
	// Set up auto pattern
	autoPattern = tutorialPattern;	
	tutorialTime = 0;
}

void EndTutorial( void )
{
	QuickFadeOut( nil );
	
	showStartMenu = true;
}

static int CalculateBalloonWidth( char *message )
{
	int maxWidth = 40;
	int currentWidth = 0;
	
	for( ;; )
	{
		char in = *message++;
		
		switch(in)
		{
			case 0:
				return (currentWidth > maxWidth)? currentWidth: maxWidth;
				
			case '\n':
				maxWidth = (currentWidth > maxWidth)? currentWidth: maxWidth;
				currentWidth = 0;
				break;
			
			default:
				currentWidth += balloonFont->width[in];
				break;
		}
	}
}

static int CalculateBalloonHeight( char *message )
{
	int lines = 2;
	char *scan = message;
	
	while( *scan ) lines += (*scan++ == '\n');

	return lines * 20;
}

void StopBalloon( void )
{
	balloonTime = 0x7FFFFFFF;
}

void StartBalloon( char *message )
{
	Point balloonTip, balloonFill;
	int replace;
	char *match[] = { "~~~~~~~~~", "|||||||||", "`````````", "{{{{{{{{{" };
	char *search;

	strcpy( balloonMsg, message );
	for( replace=0; replace<4; replace++ )
	{
		search = strstr( balloonMsg, match[replace] );
		if( search )
		{
			memcpy( search, keyBackMap[ keyCode[ replace+4 ] ], strlen( keyBackMap[ keyCode[ replace+4 ] ] ) );
		}
	}
	
	// Erase previous balloons
	SetPort( backdropPort );
	CopyBits( GetPortBitMapForCopyBits(backdropWorld), GetPortBitMapForCopyBits(backdropPort),
               &balloonRect,                           &balloonRect,
               srcCopy, nil );		                    

	// Draw empty balloon outline
	PrepareForGDrawing( balloonWorld );

	balloonRect.left = balloonRect.right - 25 - CalculateBalloonWidth ( balloonMsg );
	balloonRect.top = balloonRect.bottom - 25 - CalculateBalloonHeight( balloonMsg );

	CopyBits( GetPortBitMapForCopyBits(backdropWorld), GetPortBitMapForCopyBits(balloonWorld),
               &balloonRect,                           &balloonRect,
               srcCopy, nil );

	balloonRect.bottom -= 25;
	
	GetEdges( GetGWorldPixMap(balloonWorld), &balloonRect );
	EraseRect( &balloonRect );
	CurveEdges( GetGWorldPixMap(balloonWorld), &balloonRect );
	
	balloonTip.v = balloonRect.bottom - 2;
	balloonTip.h = balloonRect.right - 40;
	balloonFill = balloonTip;

	BlitCharacter( balloonFont, '', &balloonFill,  0,  0,  0,  0 );
	BlitCharacter( balloonFont, '', &balloonTip,  31, 31, 31,  0 );
	
	balloonRect.bottom += 25;
	
	FinishGDrawing( balloonWorld );

	// Blit empty balloon to screen
	SetPort( backdropPort );
	CopyBits( GetPortBitMapForCopyBits(balloonWorld),  GetPortBitMapForCopyBits(backdropPort),
               &balloonRect,                           &balloonRect,
               srcCopy, nil );
	
	balloonPt.h = balloonRect.left + 10;
	balloonPt.v = balloonRect.top + 10;
	balloonChar = balloonMsg;
	balloonTime = GameTickCount( );
	
	OpponentChatter( true );
}

void UpdateBalloon( void )
{
	if( control[0] != kAutoControl ) return;
	if( GameTickCount() < balloonTime ) return;
	
	if( balloonChar )
	{
		char in = *balloonChar++;
				
		switch( in )
		{
			case 0:
				OpponentChatter( false );
				balloonChar = nil;
				balloonTime += 120;
				break;
				
			case '\n':
				balloonPt.h = balloonRect.left + 10;
				balloonPt.v += 20;
				break;
				
			default:
				if( balloonFont->width[in] > 0 )
				{
					PrepareForGDrawing( balloonWorld );
					BlitCharacter( balloonFont, in, &balloonPt, 0, 0, 0, 0 );
					FinishGDrawing( balloonWorld );
					
					SetPort( backdropPort );
					CopyBits( GetPortBitMapForCopyBits(balloonWorld), GetPortBitMapForCopyBits(backdropPort),
			                    &balloonRect,                          &balloonRect,
			                    srcCopy, nil );

					balloonTime += 2;
				}
				break;			
		}	
	}
	else
	{
		SetPort( backdropPort );
		CopyBits( GetPortBitMapForCopyBits(backdropWorld), GetPortBitMapForCopyBits(backdropPort),
                    &balloonRect,                          &balloonRect,
                    srcCopy, nil );
		                    
		StopBalloon();
	}
}